#ifndef MYWINDOW2_GUEST_H_INCLUDED
#define MYWINDOW2_GUEST_H_INCLUDED

#include<gtkmm.h>
#include "mywindow2_guest_function.h"
//GUEST LOGIN : CONSTRUCTOR

mywindow2::mywindow2()
{   set_position(Gtk::WIN_POS_CENTER);
    //SIZE OF THE WINDOWS

    set_default_size(500, 200);
    set_title("GUEST LOGIN");

    //VIRTUAL BOX

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    //ADDING A GRID TO THE VBOX

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    //A LABEL AT THE TOP

    Gtk::Label *lusername = Gtk::manage(new Gtk::Label("WELCOME GUEST"));
    grid->attach(*lusername, 0, 0, 1, 1);

    Gtk::Label *space = Gtk::manage(new Gtk::Label(""));
    grid->attach(*space, 1, 1, 1, 1);

    //ADDING BUTTONS

    Gtk::Button *b1 = Gtk::manage(new Gtk::Button("BOOK SEARCH"));
    b1->signal_clicked().connect(sigc::mem_fun(*this, &mywindow2::on_button1_click));
    grid->attach(*b1, 1, 2, 1, 1);
    Gtk::Button *b2 = Gtk::manage(new Gtk::Button("APPLY FOR ACCOUNT"));
    b2->signal_clicked().connect(sigc::mem_fun(*this, &mywindow2::on_button2_click));
    grid->attach(*b2, 1, 3, 1, 1);
    Gtk::Button *b3 = Gtk::manage(new Gtk::Button("VIEW RULES AND REGULATIONS"));
    b3->signal_clicked().connect(sigc::mem_fun(*this, &mywindow2::on_button3_click));
    grid->attach(*b3, 1, 4, 1, 1);

    vbox->show_all();
}

//GUEST LOGIN : DESTRUCTOR

mywindow2::~mywindow2()
{

}

//GUEST LOGIN : MEMBER FUNCTIONS


void mywindow2::on_button1_click()
{
    book_search *popup = new book_search;
    popup->popup = new b_search;
    popup->popup->show();
}

void mywindow2::on_button2_click()
{
    set_opacity(0.5);
    apply_account *popup = new apply_account;
    popup->popup = new a_account;


    popup->popup->signal_hide().connect(sigc::bind<apply_account*>(sigc::mem_fun(*this, &mywindow2::on_popup_close), popup));

    popup->popup->show();
}

void mywindow2::on_button3_click()
{
    view_rar *popup = new view_rar;
    popup->popup = new v_rar;
    popup->popup->show();
}
#endif
